#include<can.h>
#include<p30fxxxx.h>

#if defined(__dsPIC30F5011__) || defined(__dsPIC30F6011__) || defined(__dsPIC30F6012__) || defined(__dsPIC30F5013__) \
    || defined(__dsPIC30F6013__) || defined(__dsPIC30F6014__) || defined(__dsPIC30F6010__)

/*************************************************************************
* Function Name     : CAN2Initialize
* Description       : This function configures Sync jump width, Baud Rate
*                     Pre-scaler, Phase Buffer Segment 1 and 2, and 
*                     Propogation time segment.
* Parameters        : unsigned int: config1, unsigned int: config2
* Return Value      : None
**************************************************************************/

void CAN2Initialize(unsigned int config1, unsigned int config2)
{
    C2CFG1 = config1; /* configure SJWand BRP */
    C2CFG2 = config2; /* configure PHSEG2 and PHSEG1 and PROPSEG */
}

#endif
